<?php declare(strict_types=1);

namespace Plugin\tnt_data_privacy;

use JTL\Events\Dispatcher;

use JTL\Plugin\Bootstrapper;
use JTL\Shop;
use function error_log;

class Bootstrap extends Bootstrapper
{
    /**
     * @var Helper $helper
     */
    public Helper $helper;

    /**
     * @var Bootstrap $instance
     */
    public static Bootstrap $instance;

    /**
     * @param Dispatcher $dispatcher
     * @return void
     */
    public function boot(Dispatcher $dispatcher): void
    {
        parent::boot($dispatcher);
        self::$instance = $this;

        $this->helper = new Helper(
            $this->getPlugin(),
            $this->getDB()
        );

        if (Shop::isFrontend() === true) {
            $dispatcher->listen(
                'shop.hook.' . \HOOK_BESTELLABSCHLUSS_INC_BESTELLUNGINDB_ENDE,
                array(
                    $this->helper,
                    'saveOrderAttribute'
                )
            );
            $dispatcher->listen(
                'shop.hook.' . \HOOK_BESTELLVORGANG_PAGE,
                array(
                    $this->helper,
                    'toggleCheckBox'
                )
            );
        }
    }

    /**
     * @return void
     */
    public function installed(): void
    {
        parent::installed();

        $this->helper = new Helper(
            $this->getPlugin(),
            $this->getDB()
        );
        if ($this->helper->getCheckBoxID() <= 0) {
            $checkBoxID = $this->helper->insertCheckBox();
            if ($checkBoxID === 0) {
                error_log('Could not insert checkbox with cID ' . $this->helper::CHECKBOX_CNAME);
            }
            $this->helper->insertCheckBoxText($checkBoxID);
        }
    }

    /**
     * @param $oldVersion
     * @param $newVersion
     * @return void
     */
    public function updated($oldVersion, $newVersion): void
    {
        error_log('updated from ' . $oldVersion . ' to ' . $newVersion);
    }

    /**
     * @param bool $deleteData
     * @return void
     */
    public function uninstalled(bool $deleteData = true): void
    {
        parent::uninstalled($deleteData);

        $this->helper = new Helper(
            $this->getPlugin(),
            $this->getDB()
        );
        $this->helper->removeCheckBox();
    }

    /**
     * @return void
     */
    public function enabled(): void
    {
        parent::enabled();

        $this->helper = new Helper(
            $this->getPlugin(),
            $this->getDB()
        );
        $this->helper->enableCheckBox();
    }

    /**
     * @return void
     */
    public function disabled(): void
    {
        parent::disabled();

        $this->helper = new Helper(
            $this->getPlugin(),
            $this->getDB()
        );
        $this->helper->disableCheckBox();
    }
}
