<?php declare(strict_types=1);

namespace Plugin\tnt_data_privacy;

use JTL\Plugin\Helper as PluginHelper;
use JTL\Shop;

$pluginID = Shop::Container()->getDB()->getSingleInt(
    'SELECT kPlugin FROM tplugin WHERE cPluginID = :cPluginID',
    'kPlugin',
    ['cPluginID' => 'tnt_data_privacy']
);

$plugin = PluginHelper::getLoaderByPluginID($pluginID)->init($pluginID);

$helper = new Helper(
    $plugin,
    Shop::Container()->getDB()
);

echo '>> <a href="' . $helper->getCheckBoxAdminPath() . '" target="_blank">CheckBox bearbeiten</a> <<';
