<?php

declare(strict_types=1);

namespace Plugin\tnt_coupons;

use JTL\Events\Dispatcher;
use JTL\Plugin\Bootstrapper;
use JTL\Shop;
use JTL\Smarty\JTLSmarty;
use stdClass;
use function date_create;
use function error_log;
use function is_null;
use const HOOK_ARTIKEL_CLASS_FUELLEARTIKEL;
use const HOOK_ARTIKEL_PAGE;
use const HOOK_BESTELLVORGANG_PAGE;
use const HOOK_LETZTERINCLUDE_INC;
use const HOOK_SMARTY_OUTPUTFILTER;
use const HOOK_WARENKORB_PAGE;

class Bootstrap extends Bootstrapper
{
    private Sales $sales;

    private function getUri(): string
    {
        return strtok($_SERVER['REQUEST_URI'], '?');
    }

    public function boot(Dispatcher $dispatcher)
    {
        parent::boot($dispatcher);

        $plugin      = $this->getPlugin();
        $db          = $this->getDB();
        $this->sales = new Sales(
            $plugin,
            $db
        );
        if (Shop::isFrontend() === false) {
            $updateCoupons = $db->selectSingleRow(
                'tnt_coupons_config',
                array('tkey', 'tvalue'),
                array('kupon', 0)
            )->textra ?? '';
            if (!empty($updateCoupons)) {
                $getCouponID = (int)($db->selectSingleRow('tkupon', 'cName', $updateCoupons)->kKupon
                    ?? 0);
                if ($getCouponID > 0) {
                    $db->deleteRow(
                        'tnt_coupons_config',
                        array('tkey', 'textra'),
                        array('kupon', $updateCoupons)
                    );
                    $obj         = new stdClass();
                    $obj->tkey   = 'kupon';
                    $obj->tvalue = $getCouponID;
                    $obj->textra = '';
                    $db->insertRow('tnt_coupons_config', $obj);
                }
            }
            if ($this->getUri() === '/admin/kupons.php' // Kompabilität Shop <= 5.2
                || $this->getUri() === '/admin/coupons') {
                if (isset($_POST['action'], $_POST['kKupon_arr'])
                    && $_POST['action'] === 'loeschen'
                    && count($_POST['kKupon_arr']) > 0) {
                    foreach ($_POST['kKupon_arr'] as $k) {
                        $db->deleteRow(
                            'tnt_coupons_config',
                            array('tkey', 'tvalue'),
                            array('kupon', (int)$k)
                        );
                    }
                }

                if (isset($_POST['tnt_coupons_sale'])) {
                    $kKupon = 0;
                    if (isset($_POST['kKuponBearbeiten'])) {
                        $kKupon = $_POST['kKuponBearbeiten'];
                        if ($kKupon === '') {
                            $kKupon = 0;
                        }
                        $kKupon = (int)$kKupon;
                        if ($kKupon > 0) { // Kupon wird bearbeitet
                            if ($_POST['tnt_coupons_sale'] === '1') {
                                if ($db->selectSingleRow(
                                    'tnt_coupons_config',
                                    array('tkey', 'tvalue'),
                                    array('kupon', $kKupon)
                                ) === null) {
                                    $obj         = new stdClass();
                                    $obj->tkey   = 'kupon';
                                    $obj->tvalue = $kKupon;
                                    $obj->textra = '';
                                    $db->insertRow('tnt_coupons_config', $obj);
                                }
                            } else {
                                $db->deleteRow(
                                    'tnt_coupons_config',
                                    array('tkey', 'tvalue'),
                                    array('kupon', $kKupon)
                                );
                            }
                        } elseif (!empty($_POST['cName'])) {
                            $obj         = new stdClass();
                            $obj->tkey   = 'kupon';
                            $obj->tvalue = 0;
                            $obj->textra = $_POST['cName'];
                            $db->insertRow('tnt_coupons_config', $obj);
                        }
                    }
                } else {
                    if (isset($_GET['kKupon'])) {
                        $kKupon = $_GET['kKupon'];
                        if ($kKupon === '') {
                            $kKupon = 0;
                        }
                        $kKupon       = (int)$kKupon;
                        $default_ja   = '';
                        $default_nein = ' selected';
                        $is_a_sale    = new stdClass();
                        if ($kKupon > 0) {
                            $is_a_sale = $db->selectSingleRow(
                                'tnt_coupons_config',
                                array('tkey', 'tvalue'),
                                array('kupon', $kKupon)
                            );
                        }
                        if (((int)($_GET['sale'] ?? 0)) === 1
                            || isset($is_a_sale->tkey)) {
                            $default_ja   = ' selected';
                            $default_nein = '';
                        }
                        echo "<script type='text/javascript'>document.addEventListener('DOMContentLoaded', function(e){var container = $(\"#content form .card-footer.save-wrapper\");container.before(\"<div class='card settings'><div class='card-header'><div class='subheading1'>Sales Aktionen</div><hr class='mb-n3'></div><div class='card-body'><div class='form-group form-row align-items-center'><label class='col col-sm-4 col-form-label text-sm-right' for='tnt_coupons_sale'>Kupon als Sale Aktion verwenden?</label><div class='col-sm pl-sm-3 pr-sm-5 order-last order-sm-2'><select name='tnt_coupons_sale' id='tnt_coupons_sale' class='custom-select combo'><option value='1'" . $default_ja . ">Ja</option><option value='0'" . $default_nein . ">Nein</option></select></div><div class='col-auto ml-sm-n4 order-2 order-sm-3'><span data-html='true' data-toggle='tooltip' data-placement='left' title='' data-original-title='Aktivieren Sie diesen Kupon als Sale'><span class='fas fa-info-circle fa-fw'></span></span></div></div></div>\");});</script>";
                    }
                }
            } elseif ($this->getUri() === '/admin/plugin.php'
                || $this->getUri() === '/admin/plugin/' . $plugin->getID()) {
                if (isset($_GET['tnt_coupon_stats'])) {
                    // Load Sale Statistics
                    $kKupon = $_GET['kupon'];
                    if ($kKupon === '') {
                        $kKupon = 0;
                    }
                    $kKupon                  = (int)$kKupon;
                    $data                    = $this->sales->stats($kKupon);
                    $data->dGueltigAbFormat  = date_create(
                        $data->dGueltigAb ?? 'now'
                    )->format('d.m.Y H:i');
                    $data->dGueltigBisFormat = date_create(
                        $data->dGueltigBis ?? '+1 day'
                    )->format('d.m.Y H:i');

                    $chartData         = new stdClass();
                    $chartData->labels = array();
                    $chartData->series = array(array(), array());
                    foreach ($data->umsatzDavor as $v) {
                        $chartData->labels[]    = $v->dZeit;
                        $chartData->series[1][] = (float)$v->nCount;
                        $chartData->series[0][] = 'null';
                    }
                    foreach ($data->umsatzSale as $v) {
                        if ($chartData->labels[count($chartData->labels) - 1] === $v->dZeit) {
                            array_pop($chartData->series[0]);
                            array_pop($chartData->labels);
                        }
                        $chartData->labels[]    = $v->dZeit;
                        $chartData->series[0][] = (float)$v->nCount;
                    }
                    if (count($data->umsatzDavor) === 0) {
                        unset($chartData->series[1]);
                    }
                    $data->chart = Shop::Smarty()->assign('baseURL', Shop::getURL())
                        ->assign('chart_data', \json_encode($chartData))
                        ->fetch(__DIR__ . '/chart.tpl');
                    echo \json_encode($data);
                    exit();
                }

                if (isset($_GET['tnt_coupon_sale'])) {
                    $kKupon       = (int)($_GET['kupon'] ?? 0);
                    $couponConfig = $kKupon > 0
                        ? $db->selectSingleRow(
                            'tnt_coupons_config',
                            array('tkey', 'tvalue'),
                            array('kupon', $kKupon)
                        )->textra ?? '{}'
                        : '{}';
                    echo $couponConfig === '' ? '{}' : $couponConfig;
                    exit();
                }
            }

            return;
        }

        unset($_SESSION['tnt_coupons_product']);
        $dispatcher->listen('shop.hook.' . HOOK_SMARTY_OUTPUTFILTER, array($this->sales, 'init'));
        $dispatcher->listen('shop.hook.' . HOOK_LETZTERINCLUDE_INC, array($this->sales, 'wk_hinweis'));
        $dispatcher->listen('shop.hook.' . HOOK_ARTIKEL_PAGE, array($this->sales, 'artikelseite'));
        $dispatcher->listen('shop.hook.' . HOOK_ARTIKEL_CLASS_FUELLEARTIKEL, array($this->sales, 'fuelleArtikel'));
        $dispatcher->listen('shop.hook.' . HOOK_BESTELLVORGANG_PAGE, array($this->sales, 'applyCoupon'));
        $dispatcher->listen('shop.hook.' . HOOK_WARENKORB_PAGE, array($this->sales, 'applyCoupon'));
    }

    public function renderAdminMenuTab(string $tabName, int $menuID, JTLSmarty $smarty): string
    {
        $plugin      = $this->getPlugin();
        $db          = $this->getDB();
        $this->sales = new Sales(
            $plugin,
            $db
        );
        $isShop52    = (int)\str_replace('.', '', APPLICATION_VERSION) >= 520;
        $url         = Shop::getURL();
        $kuponurl    = ($isShop52) ? 'coupons' : 'kupons.php';
        $smarty->assign('plugin_pfad', $url . '/plugins/tnt_coupons/');
        $smarty->assign('admin_pfad', $url . '/admin/');
        $smarty->assign('coupons_pfad', $url . '/admin/' . $kuponurl);

        $css_additional = '<link rel="stylesheet" media="screen" href="' . Shop::getURL()
            . '/plugins/tnt_coupons/adminmenu/vendor/simplebar/dist/simplebar.min.css"/>';
        $js_additional  = '<script src="' . Shop::getURL()
            . '/plugins/tnt_coupons/adminmenu/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>'
            . '<script src="' . Shop::getURL()
            . '/plugins/tnt_coupons/adminmenu/vendor/simplebar/dist/simplebar.min.js"></script>'
            . '<script src="' . Shop::getURL()
            . '/plugins/tnt_coupons/adminmenu/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>';

        $smarty->assign('css_additional', $css_additional);
        $smarty->assign('js_additional', $js_additional);

        if ($tabName === 'Support / Anfragen') {
            $tpl_path = rtrim($this->getPlugin()->getPaths()->getAdminPath(), '/');
            return $smarty->fetch($tpl_path . '/templates/backoffice.tpl');
        }

        //$dbObj = $db->selectSingleRow("tnt_coupons_config", "cTemplate", "coupons");
        if (!empty($_POST['tnt_sale_kupon'])) {
            $kkupon = (int)$_POST['tnt_sale_kupon'];
            if ($kkupon > 0) {
                $files    = $_FILES ?? [];
                $sale_img = '';
                foreach ($files as $k => $v) {
                    if ($k === 'tnt_cp_file'
                        && isset($v['size'])
                        && $v['size'] > 0
                        && !empty($v['tmp_name'])
                        && !empty($v['type'])) {
                        $ext = '';
                        switch ($v['type']) {
                            case 'image/png':
                                $ext = '.png';
                                break;
                            case 'image/gif':
                                $ext = '.gif';
                                break;
                            case 'image/jpeg':
                                $ext = '.jpg';
                                break;
                            case 'image/webp':
                                $ext = '.webp';
                                break;
                        }
                        if ($ext !== '') {
                            $paths    = $this->getPlugin()->getPaths();
                            $imageDir = $paths->getBasePath() . 'images/';
                            $sale_img = $paths->getBaseUrl() . 'images/sale_' . $kkupon . $ext;

                            if (!\is_dir($imageDir) && !mkdir($imageDir, 0755) && !is_dir($imageDir)) {
                                throw new \RuntimeException(
                                    'Error creating the tnt_coupons image directory.'
                                );
                            }

                            \move_uploaded_file(
                                $v['tmp_name'],
                                $imageDir . 'sale_' . $kkupon . $ext
                            );
                        }
                    }
                }
                unset($_POST['tnt_sale_kupon']);
                if (!empty($sale_img)) {
                    $_POST['tnt_cp_file'] = $sale_img;
                }
                $obj         = new stdClass();
                $obj->tkey   = 'kupon';
                $obj->tvalue = $kkupon;
                $obj->textra = \json_encode($_POST);
                $db->updateRow('tnt_coupons_config', array('tkey', 'tvalue'), array('kupon', $kkupon), $obj);
            }
        }

        $template = 'einstellungen.tpl';

        $allCoupons = $this->sales->getCoupons(true);
        $coupons    = array('active' => [], 'upcoming' => [], 'past' => []);
        foreach ($allCoupons as $cp) {
            $details               = $this->sales->convertToSale($cp, false, 3);
            $cp->dGueltigAbFormat  = (!is_null($cp->dGueltigAb) && !empty($cp->dGueltigAb))
                ? date_create($cp->dGueltigAb)->format('d.m.Y H:i') : '';
            $cp->dGueltigBisFormat = (!is_null($cp->dGueltigBis) && !empty($cp->dGueltigBis))
                ? date_create($cp->dGueltigBis)->format('d.m.Y H:i') : '';
            $cp->sale_img          = '';
            if (!is_null($cp->textra) && !empty($cp->textra)) {
                $json         = json_decode($cp->textra);
                $cp->sale_img = $json->tnt_cp_file ?? '';
            }
            if (date_create($cp->dGueltigAb) > date_create()) {
                if (isset($details->hints)) {
                    $cp->details = $details->hints;
                } else {
                    $cp->details = array('-');
                }
                $coupons['upcoming'][] = $cp;
            } elseif ($cp->cAktiv === 'Y') {
                if (isset($details->hints)) {
                    $cp->details = $details->hints;
                } else {
                    $cp->details = array('-');
                }
                $coupons['active'][] = $cp;
            } else {
                if (isset($details->hints)) {
                    $cp->details = $details->hints;
                } else {
                    $cp->details = array('-');
                }
                $coupons['past'][] = $cp;
            }
        }
        $smarty->assign(
            'allCPs',
            $coupons
        );
        $tpl_path = rtrim($this->getPlugin()->getPaths()->getAdminPath(), '/');

        return $smarty->fetch($tpl_path . '/templates/' . $template);
    }
}
