{$css_additional}
<link rel="stylesheet" media="screen" href="{$plugin_pfad}adminmenu/css/theme.min.css">
<script>
    $(document).ready(function () {
        $("#content_wrapper").css("position", "relative");
    });
</script>
<style>
    .backend-wrapper > .backend-main > .backend-navbar {
        box-shadow: none;
    }

    .navbar-toggler.sidebar-toggler {
        background-color: rgba(var(--bs-dark-rgb), 1) !important;
    }

    #tabs-tnt_coupons .tab-content {
        padding: 0;
    }

    #tabs-tnt_coupons .tab-content .tab-pane:not(:first-child) {
        padding: 1.5rem;
    }
</style>
<div id="Acz" style="background-color:#eff1f4;">

    <div class="page-title-overlap bg-accent pt-4">
        <div class="container d-flex flex-wrap flex-sm-nowrap justify-content-center justify-content-sm-between align-items-center pt-2">
            <div class="d-flex align-items-center pb-3">
                <div class="img-thumbnail rounded-circle position-relative flex-shrink-0" style="width: 6.375rem;">
                    <a href="https://tnt-ai.com/" target="_blank"><img class="rounded-circle"
                                                                       src="{$plugin_pfad}adminmenu/img/tntai_logo.png"
                                                                       alt="tntAI"></a>
                </div>
                <div class="ps-3">
                    <h3 class="text-light fs-lg mb-0">Sales Aktionen</h3>
                    <span class="d-block text-light fs-ms opacity-60 py-1">Seit 12/2021 für JTL Shop5 erhältlich</span>
                </div>
            </div>
            <div class="d-flex">
                <div class="text-sm-end">
                    <div class="star-rating"></div>
                </div>
            </div>
        </div>
    </div>
    <div class="container mb-5 pb-3">
        <div class="bg-light shadow-lg rounded-3 overflow-hidden">
            <div class="row">

                <section class="col-12">
                    <ul class="nav nav-pills mb-3 bg-secondary px-3 pb-3 border-bottom" role="tablist">
                        <li class="nav-item pt-3">
                            <a href="#sales_active" data-scroll class="btn btn-accent">
                                <i class="ci-check me-1"></i>
                                Aktiv
                            </a>
                        </li>
                        <li class="nav-item pt-3">
                            <a href="#sales_upcoming" data-scroll class="btn btn-warning">
                                <i class="ci-time me-1"></i>
                                Erscheinend
                            </a>
                        </li>
                        <li class="nav-item pt-3">
                            <a href="#sales_past" data-scroll class="btn btn-primary">
                                <i class="ci-view-list me-1"></i>
                                Abgeschlossen
                            </a>
                        </li>
                        <li class="flex-grow-1"></li>
                        <li class="nav-item pt-3 float-end">
                            <a href="{$coupons_pfad}?kKupon=0&cKuponTyp=standard&sale=1&token={$smarty.session.jtl_token}"
                               class="btn btn-success" target="_blank">
                                <i class="ci-add me-1"></i>
                                Erstellen
                            </a>
                        </li>
                    </ul>
                    <div class="pt-2 px-4 pt-4 tab-content">
                        <div class="d-block" id="Einstellungen">
                            <div class="w-100">
                                <div class="mx-2 mb-3 border-bottom border-accent d-inline-block">
                                    <h3><span class="badge rounded-pill bg-accent me-2"><i class="ci-check"></i></span>Aktive
                                        Sales</h3>
                                </div>
                                <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-3 mb-3" id="sales_active">
                                    {foreach from=$allCPs["active"] item=cp key=k}
                                        <div class="col">
                                            <div class="card bg-secondary shadow">
                                                {if $cp->sale_img !== ""}
                                                    <img src="{$cp->sale_img}" class="card-img-top" alt="Card image">
                                                {/if}
                                                <div class="card-header bg-dark">
                                                    <h5 class="card-title text-light m-0 lead">{$cp->Titel}</h5>
                                                </div>
                                                <div class="card-body">
                                                    <p class="card-text">
                                                        {$cp->fWert} {if $cp->cWertTyp === "prozent"}%{else}€{/if}
                                                        Rabatt mit dem Code
                                                        <mark class="px-1">{$cp->cCode}</mark>
                                                        mit folgenden Konditionen:
                                                    <ul class="list-group list-group-flush">
                                                        {foreach $cp->details as $hint}
                                                            <li class="list-group-item fs-sm bg-transparent">{$hint}</li>
                                                        {/foreach}
                                                    </ul>
                                                    </p>
                                                    <a href="#saleModal" class="btn btn-sm btn-primary ajax_sale"
                                                       data-kupon="{$cp->kKupon}"><i class="ci-settings me-2"></i>Konfigurieren</a>
                                                    <a href="#statsModal"
                                                       class="btn btn-sm btn-outline-primary shadow-none ajax_stats"
                                                       data-kupon="{$cp->kKupon}"><i class="ci-announcement me-2"></i>Statistik</a>
                                                </div>
                                                <div class="card-footer text-light bg-dark">
                                                    <small class="">
                                                        Gültig von <span
                                                                class="text-success">{$cp->dGueltigAbFormat}</span>
                                                        {if $cp->dGueltigBisFormat !== ""} - <span
                                                                class="text-primary">{$cp->dGueltigBisFormat}</span>{/if}
                                                    </small>
                                                </div>
                                            </div>
                                        </div>
                                    {/foreach}
                                </div>

                                <div class="mx-2 mb-3 border-bottom border-warning d-inline-block">
                                    <h3><span class="badge rounded-pill bg-warning me-2"><i class="ci-time"></i></span>Bald
                                        erscheinende Sales</h3>
                                </div>
                                <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-3 mb-3" id="sales_upcoming">
                                    {foreach from=$allCPs["upcoming"] item=cp key=k}
                                        <div class="col">
                                            <div class="card bg-secondary shadow">
                                                {if $cp->sale_img !== ""}
                                                    <img src="{$cp->sale_img}" class="card-img-top" alt="Card image">
                                                {/if}
                                                <div class="card-header bg-dark">
                                                    <h5 class="card-title text-light m-0 lead">{$cp->Titel}</h5>
                                                </div>
                                                <div class="card-body">
                                                    <p class="card-text">
                                                        {$cp->fWert} {if $cp->cWertTyp === "prozent"}%{else}€{/if}
                                                        Rabatt mit dem Code
                                                        <mark class="px-1">{$cp->cCode}</mark>
                                                        mit folgenden Konditionen:
                                                    <ul class="list-group list-group-flush">
                                                        {foreach $cp->details as $hint}
                                                            <li class="list-group-item fs-sm bg-transparent">{$hint}</li>
                                                        {/foreach}
                                                    </ul>
                                                    </p>
                                                    <a href="#saleModal" class="btn btn-sm btn-primary w-100 ajax_sale"
                                                       data-kupon="{$cp->kKupon}"><i class="ci-settings me-2"></i>Konfigurieren</a>
                                                </div>
                                                <div class="card-footer text-light bg-dark">
                                                    <small class="">
                                                        Gültig von <span
                                                                class="text-success">{$cp->dGueltigAbFormat}</span>
                                                        {if $cp->dGueltigBisFormat !== ""} - <span
                                                                class="text-primary">{$cp->dGueltigBisFormat}</span>{/if}
                                                    </small>
                                                </div>
                                            </div>
                                        </div>
                                    {/foreach}
                                </div>

                                <div class="mx-2 mb-3 border-bottom border-primary d-inline-block">
                                    <h3><span class="badge rounded-pill bg-primary me-2"><i
                                                    class="ci-view-list"></i></span>Abgeschlossene Sales</h3>
                                </div>
                                <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-3 mb-3" id="sales_past">
                                    {foreach from=$allCPs["past"] item=cp key=k}
                                        <div class="col">
                                            <div class="card bg-secondary shadow">
                                                {if $cp->sale_img !== ""}
                                                    <img src="{$cp->sale_img}" class="card-img-top" alt="Card image">
                                                {/if}
                                                <div class="card-header bg-dark">
                                                    <h5 class="card-title text-light m-0 lead">{$cp->Titel}</h5>
                                                </div>
                                                <div class="card-body">
                                                    <p class="card-text">
                                                        {$cp->fWert} {if $cp->cWertTyp === "prozent"}%{else}€{/if}
                                                        Rabatt mit dem Code
                                                        <mark class="px-1">{$cp->cCode}</mark>
                                                        mit folgenden Konditionen:
                                                    <ul class="list-group list-group-flush">
                                                        {foreach $cp->details as $hint}
                                                            <li class="list-group-item fs-sm bg-transparent">{$hint}</li>
                                                        {/foreach}
                                                    </ul>
                                                    </p>
                                                    <a href="#saleModal" class="btn btn-sm btn-primary ajax_sale"
                                                       data-kupon="{$cp->kKupon}"><i class="ci-settings me-2"></i>Konfigurieren</a>
                                                    <a href="#statsModal"
                                                       class="btn btn-sm btn-outline-primary shadow-none ajax_stats"
                                                       data-kupon="{$cp->kKupon}"><i class="ci-announcement me-2"></i>Statistik</a>
                                                </div>
                                                <div class="card-footer text-light bg-dark">
                                                    <small class="">
                                                        Gültig von <span
                                                                class="text-success">{$cp->dGueltigAbFormat}</span>
                                                        {if $cp->dGueltigBisFormat !== ""} - <span
                                                                class="text-primary">{$cp->dGueltigBisFormat}</span>{/if}
                                                    </small>
                                                </div>
                                            </div>
                                        </div>
                                    {/foreach}
                                </div>

                            </div>
                        </div>

                    </div>
                </section>
            </div>

        </div>
    </div>

</div>

<div class="modal fade" tabindex="-1" role="dialog" id="saleModal">
    <div class="modal-dialog modal-lg" role="document">
        <form class="modal-content" target="_self" novalidate="novalidate" action="" method="post"
              enctype="multipart/form-data">
            <div class="modal-header">
                <h5 class="modal-title">Einstellungen zum Sale</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" name="tnt_sale_kupon" value="0"/>
                <div class="row mb-4">
                    <div class="col-12">
                        <h6>Design</h6>
                    </div>
                    <div class="col-md-12 mb-3">
                        <label for="tnt_cp_layout" class="form-label">Balken Layout</label>
                        <select class="form-select" id="tnt_cp_layout" name="tnt_cp_layout">
                            <option value="header">Balken über dem Header</option>
                            <option value="menu">Balken unter dem Menü</option>
                            <option value="none">Keinen Balken anzeigen</option>
                        </select>
                    </div>
                    <div class="col-auto mb-3">
                        <label for="tnt_cp_color1" class="form-label">Balkenfarbe</label>
                        <input class="form-control form-control-color" type="color" name="tnt_cp_color1"
                               id="tnt_cp_color1" value="#373f50" data-default="#373f50">
                    </div>
                    <div class="col-auto mb-3">
                        <label for="tnt_cp_color2" class="form-label">Textfarbe</label>
                        <input class="form-control form-control-color" type="color" name="tnt_cp_color2"
                               id="tnt_cp_color2" value="#ffffff" data-default="#ffffff">
                    </div>
                </div>
                <div class="row mb-4">
                    <div class="col-12">
                        <h6>PopUp</h6>
                    </div>
                    <div class="col-12">
                        <div class="row mb-3">
                            <div class="col-12 mb-3">
                                <label for="tnt_cp_file" class="form-label">Bild</label>
                                <input class="form-control" type="file" id="tnt_cp_file" name="tnt_cp_file"
                                       accept="image/png, image/gif, image/jpeg, image/webp">
                            </div>
                            <div class="col-12">
                                <label for="tnt_cp_description" class="form-label">HTML</label>
                                <textarea class="ckeditor tinymce form-control" name="tnt_cp_description"
                                          id="tnt_cp_description"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 mb-3">
                        <label for="tnt_cp_popupSize" class="form-label">PopUp Grösse</label>
                        <select class="form-select" id="tnt_cp_popupSize" name="tnt_cp_popupSize">
                            <option value="modal-sm">SM</option>
                            <option value="">MD</option>
                            <option value="modal-lg">LG</option>
                            <option value="modal-xl">XL</option>
                        </select>
                    </div>
                </div>
                <div class="row mb-4">
                    <div class="col-12">
                        <h6>Einstellungen</h6>
                    </div>
                    <div class="col-12">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="tnt_cp_check1" id="tnt_cp_check1">
                            <label class="form-check-label" for="tnt_cp_check1">Countdown bis zum Start des Sale
                                anzeigen</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="tnt_cp_check2" id="tnt_cp_check2">
                            <label class="form-check-label" for="tnt_cp_check2">Countdown bis zum Ende des Sale
                                anzeigen</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="tnt_cp_check3" id="tnt_cp_check3">
                            <label class="form-check-label" for="tnt_cp_check3">Warenkorbhinweis anzeigen</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="tnt_cp_check4" id="tnt_cp_check4">
                            <label class="form-check-label" for="tnt_cp_check4">Alle Preise rabattiert anzeigen</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="tnt_cp_check5" id="tnt_cp_check5">
                            <label class="form-check-label" for="tnt_cp_check5">Sales automatisch im Warenkorb
                                anwenden</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="tnt_cp_check6" id="tnt_cp_check6"
                                   checked>
                            <label class="form-check-label" for="tnt_cp_check6">Modal bei Klick anzeigen</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-sm btn-secondary configKupon" target="_blank"><i
                            class="ci-settings me-2"></i>Weitere Einstellungen</a>
                <button type="submit" class="btn btn-primary btn-sm"><i class="ci-check me-2"></i>Speichern</button>
            </div>
        </form>
    </div>
</div>

<div class="modal fade" tabindex="-1" role="dialog" id="statsModal">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Sale Statistik</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Schliessen</button>
            </div>
        </div>
    </div>
</div>

{$js_additional}
<script src="{$plugin_pfad}adminmenu/js/theme.min.js"></script>
{inline_script}
    <script>
        function removeImage(modalID, key) {
            var row = $("#" + modalID + " input[name='" + key + "'][type='file']").closest(".row");
            row.find(".col-auto").remove();
            $("#" + modalID + " input[name='" + key + "'][type='hidden']").remove();
        }

        function fillForm(json, modalID) {
            $("#" + modalID + " form input[type='checkbox']").prop("checked", false);
            $("#" + modalID + " form select option[selected='selected']").prop("selected", false);
            $("#" + modalID + " form select option[value='none']").prop("selected", true);
            $("#" + modalID + " form input[type='hidden'][name!='tnt_sale_kupon']").remove();
            $("#" + modalID + " form button[onclick]").closest(".col-auto").remove();
            var colorInputs = $("#" + modalID + " form input[type='color'][data-default]");
            if (colorInputs.length) {
                colorInputs.each(function () {
                    $(this).val($(this).attr("data-default"));
                });
            }
            $.each(json, function (key, val) {
                if (key === "tnt_cp_description" && val !== "") {
                    if (typeof CKEDITOR !== 'undefined') {
                        // Fill in the CKeditor
                        CKEDITOR.instances[key].setData(val);
                    } else {
                        // Fill in the TinyMCEditor
                        tinymce.get("tnt_cp_description").setContent(val);
                    }
                }

                if (key === "tnt_cp_file" && val !== "") {
                    var row = $("#" + modalID + " input[name='" + key + "']").closest(".row");
                    if (!row.find(".col-auto").length) {
                        row.prepend("<div class='col-auto'><button type='button' onclick='removeImage(\"" + modalID + "\", \"" + key + "\");' class='btn btn-primary btn-sm btn-icon' style='position: absolute;bottom: 0;right: 0;'><i class='ci-trash'></i></button><img src='" + val + "' width='100px' class='img-thumbnail' /></div>");
                        $("#" + modalID + " form").append("<input type='hidden' name='" + key + "' value='" + val + "' />");
                    }
                } else {
                    if (val === "on") {
                        $("#" + modalID + " input[name='" + key + "']").prop("checked", true);
                    } else {
                        if ($("#" + modalID + " select[name='" + key + "']").length) {
                            $("#" + modalID + " select[name='" + key + "'] option[selected='selected']").prop("selected", false);
                            $("#" + modalID + " select[name='" + key + "'] option[value='" + val + "']").prop("selected", true);
                        } else {
                            $("#" + modalID + " input[name='" + key + "']").val(val);
                        }
                    }
                }
            });
        }

        function configSale(btn, param) {
            var btnHTML = btn.html();
            var modalID = btn.attr("href");
            if (modalID != "" && param.hasOwnProperty('kupon')) {
                $(modalID + " a.configKupon").attr("href", "{$coupons_pfad}?kKupon=" + param['kupon'] + "&token={$smarty.session.jtl_token}");
                $(modalID + " input[name='tnt_sale_kupon']").val(param['kupon']);
                modalID = modalID.substring(1);
                btn.html('<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>Lade Daten');

                var request = $.ajax({
                    method: "GET",
                    data: param,
                    dataType: "json"
                });

                request.done(function (json) {
                    btn.html(btnHTML);
                    var myModal = new bootstrap.Modal(document.getElementById(modalID));
                    myModal.show();
                    document.getElementById(modalID).addEventListener('shown.bs.modal', function (event) {
                        fillForm(json, modalID);
                    });
                });

                request.fail(function (jqXHR, textStatus) {
                    btn.html(btnHTML);
                    console.log("Request failed: " + textStatus);
                });
            }
        }

        function getStats(btn, param) {
            var btnHTML = btn.html();
            var modalID = btn.attr("href");
            if (modalID != "") {
                modalID = modalID.substring(1);
                btn.html('<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>Lade Daten');

                var request = $.ajax({
                    method: "GET",
                    data: param,
                    dataType: "json"
                });

                request.done(function (json) {
                    btn.html(btnHTML);
                    if (json.hasOwnProperty('Titel')) {
                        var gespart = "0,00 €";
                        var verwendet = 0;
                        var GueltigAb = "";
                        var GueltigBis = "";
                        var chart = "";
                        var verwendetTotal = "0";
                        var showChart = false;
                        if ((json.hasOwnProperty('umsatzDavor') && json["umsatzDavor"].length > 0) || (json.hasOwnProperty('umsatzSale') && json["umsatzSale"].length > 0)) {
                            showChart = true;
                        }
                        if (json.hasOwnProperty('Gespart') && json["Gespart"] !== null) {
                            {literal}
                            gespart = parseFloat(json["Gespart"]).toLocaleString("de-DE", {maximumFractionDigits: 2}) + " €";
                            {/literal}
                        }
                        if (json.hasOwnProperty('totalOrders') && json["totalOrders"] !== null) {
                            verwendetTotal = parseInt(json["totalOrders"]);
                        }
                        if (json.hasOwnProperty('nVerwendungenBisher') && json["nVerwendungenBisher"] !== null) {
                            verwendet = parseInt(json["nVerwendungenBisher"]);
                        }
                        if (json.hasOwnProperty('dGueltigAbFormat') && json["dGueltigAbFormat"] !== null) {
                            GueltigAb = json["dGueltigAbFormat"];
                        }
                        if (json.hasOwnProperty('dGueltigBisFormat') && json["dGueltigBisFormat"] !== null) {
                            GueltigBis = json["dGueltigBisFormat"];
                        }
                        if (json.hasOwnProperty('chart') && json["chart"] !== null) {
                            chart = json["chart"];
                        }
                        $("#" + modalID + " .modal-title").html(json["Titel"]);
                        // GENERATE BODY
                        var _body = "<h6>";
                        if (GueltigAb !== "") {
                            _body += "Im Zeitraum vom " + GueltigAb;
                            if (GueltigBis !== "") {
                                _body += " bis " + GueltigBis;
                            }
                        } else {
                            _body += "Im aktivem Zeitraum";
                        }
                        _body += ":</h6>";
                        _body += "<ul class='list-group list-group-flush'>";

                        _body += "<li class='list-group-item fs-sm'>Wurde der Sale bei " + verwendet + " von " + verwendetTotal + " Bestellungen verwendet.</li>";

                        _body += "<li class='list-group-item fs-sm'>Haben Kunden " + gespart + " gespart.</li>";

                        _body += "</ul>";

                        _body += chart;

                        $("#" + modalID + " .modal-body").html(_body);
                        var myModal = new bootstrap.Modal(document.getElementById(modalID));
                        myModal.show();
                        if (showChart) {
                            document.getElementById(modalID).addEventListener('shown.bs.modal', function (event) {
                                createChart();
                            });
                        }
                    }
                });

                request.fail(function (jqXHR, textStatus) {
                    btn.html(btnHTML);
                    console.log("Request failed: " + textStatus);
                });
            }
        }

        $("a.ajax_stats").on("click", function (e) {
            e.preventDefault();
            var param = $(this).data();
            param["jtl_token"] = "{$smarty.session.jtl_token}";
            param["tnt_coupon_stats"] = 1;
            getStats($(this), param);
            return false;
        });

        $("a.ajax_sale").on("click", function (e) {
            e.preventDefault();
            var param = $(this).data();
            param["jtl_token"] = "{$smarty.session.jtl_token}";
            param["tnt_coupon_sale"] = 1;
            configSale($(this), param);
            return false;
        });

        $("#saleModal form").on("submit", function () {
            $("#saleModal form button[type='submit']").html('<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>Speichere Daten');
            return true;
        });

    </script>
{/inline_script}
