<?php declare(strict_types=1);

namespace Plugin\tnt_whatsapp;

use JTL\Alert\Alert;
use JTL\Catalog\Category\Kategorie;
use JTL\Catalog\Product\Artikel;
use JTL\Consent\Item;
use JTL\Events\Dispatcher;
use JTL\Events\Event;
use JTL\Helpers\Form;
use JTL\Helpers\Request;
use JTL\Link\LinkInterface;
use JTL\Plugin\Bootstrapper;
use JTL\Shop;
use JTL\Smarty\JTLSmarty;
use function error_log;
use const HOOK_LETZTERINCLUDE_INC;

class Bootstrap extends Bootstrapper
{
    private $helper;

    public function boot(Dispatcher $dispatcher)
    {
        parent::boot($dispatcher);

        if (Shop::isFrontend() === false) {
            return;
        }
        $plugin = $this->getPlugin();
        $this->helper = new tntHelper(
            $plugin,
            $this->getDB()
        );
        $dispatcher->listen('shop.hook.' . HOOK_LETZTERINCLUDE_INC, array($this->helper, "render"));
    }

    public function installed()
    {
        parent::installed();
    }

    public function updated($oldVersion, $newVersion)
    {
        error_log('updated from ' . $oldVersion . ' to ' . $newVersion);
    }

    public function uninstalled(bool $deleteData = true)
    {
        parent::uninstalled($deleteData);
    }

}
