<?php declare(strict_types=1);

use JTL\Shop;

$options = [];
$db = Shop::Container()->getDB();
$admins = $db->executeQuery("
	SELECT tadminlogin.kAdminlogin, tadminlogin.cName, tadminloginattribut.cAttribValue
	FROM tadminlogin
	LEFT JOIN tadminloginattribut
	ON tadminlogin.kAdminlogin = tadminloginattribut.kAdminlogin AND tadminloginattribut.cName LIKE 'useAvatarUpload'
	WHERE bAktiv LIKE 1
", 2);
$cnt = 2;
if (count($admins) > 0) {
    $option = new stdClass();
    $option->cWert = "N";
    $option->cName = __("Nein");
    $option->nSort = 1;
    $options[] = $option;
    foreach ($admins as $admin) {
        if ($admin->cAttribValue != "") {
            $option = new stdClass();
            $option->cWert = $admin->cAttribValue;
            $option->cName = __($admin->cName);
            $option->nSort = $cnt;
            $options[] = $option;
            $cnt++;
        }
    }
} else {
    $option = new stdClass();
    $option->cWert = "N";
    $option->cName = __("Es wurde kein Benutzer mit einem Avatar gefunden");
    $option->nSort = 1;
    $options[] = $option;
}

return $options;