<?php declare(strict_types=1);

namespace Plugin\tnt_whatsapp;

use JTL\Cache\JTLCacheInterface;
use JTL\DB\DbInterface;
use JTL\Plugin\PluginInterface;
use JTL\Shop;

class tntHelper
{

    private $extension;
    private $db;

    public function __construct(PluginInterface $extension, DbInterface $db)
    {
        $this->extension = $extension;
        $this->db        = $db;
    }

    public function render(): bool
    {
        date_default_timezone_set('Europe/Berlin');
        $smarty         = Shop::Smarty();
        $config         = $this->extension->getConfig();
        $btn_show_modus = $config->getValue('tnt_whatsapp_show_always');
        if ($btn_show_modus !== 'always') {
            $today         = explode('-', date('Y-m-d'));
            $businesstimes = array(
                array($config->getValue('tnt_whatsapp_businesstimes_mo_von'), $config->getValue('tnt_whatsapp_businesstimes_mo_bis')),
                array($config->getValue('tnt_whatsapp_businesstimes_di_von'), $config->getValue('tnt_whatsapp_businesstimes_di_bis')),
                array($config->getValue('tnt_whatsapp_businesstimes_mi_von'), $config->getValue('tnt_whatsapp_businesstimes_mi_bis')),
                array($config->getValue('tnt_whatsapp_businesstimes_do_von'), $config->getValue('tnt_whatsapp_businesstimes_do_bis')),
                array($config->getValue('tnt_whatsapp_businesstimes_fr_von'), $config->getValue('tnt_whatsapp_businesstimes_fr_bis')),
                array($config->getValue('tnt_whatsapp_businesstimes_sa_von'), $config->getValue('tnt_whatsapp_businesstimes_sa_bis')),
                array($config->getValue('tnt_whatsapp_businesstimes_so_von'), $config->getValue('tnt_whatsapp_businesstimes_so_bis')),
                $config->getValue('tnt_whatsapp_businesstimes_next_close_day')
            );
            if (!empty($businesstimes[7]) && strpos($businesstimes[7], '-') !== false) {
                if (strpos($businesstimes[7], '-') !== false) {
                    $businesstimes[7] = explode('-', $businesstimes[7]);
                } elseif (strpos($businesstimes[7], '/') !== false) {
                    $businesstimes[7] = explode('/', $businesstimes[7]);
                }
                if (is_array($businesstimes[7]) && count($businesstimes[7]) === 3 && $businesstimes[7][0] === $today[0] && $businesstimes[7][1] === $today[1] && $businesstimes[7][2] === $today[2]) {
                    return false;
                }
            }
            $weekday = date('N') - 1;
            if ($weekday >= 0 && $weekday <= 6 && isset($businesstimes[$weekday])) {
                if (empty($businesstimes[$weekday][0]) || empty($businesstimes[$weekday][1])) {
                    return false;
                }
                if (time() < strtotime($businesstimes[$weekday][0]) || time() > strtotime($businesstimes[$weekday][1])) {
                    return false;
                }
            }
        }
        $smarty->assign('tnt_whatsapp_style', $config->getValue('tnt_whatsapp_style'));
        $plugin_pfad = $this->db->executeQuery("SELECT cVerzeichnis FROM tplugin WHERE cPluginID LIKE 'tnt_whatsapp'", 1);
        $plugin_url  = '';
        $shop_url    = Shop::getURL();
        if (isset($plugin_pfad->cVerzeichnis)) {
            $plugin_url  = $shop_url;
            $plugin_url .= '/plugins/' . $plugin_pfad->cVerzeichnis . '/';
            $nummer      = $config->getValue('tnt_whatsapp_show_number');
            if (substr($nummer, 0, 2) == '00') {
                $nummer = substr($nummer, 2);
            } elseif (substr($nummer, 0, 1) == '+') {
                $nummer = substr($nummer, 1);
            }
            $vorwahl = $config->getValue('tnt_whatsapp_laendervorwahl');
            if ($vorwahl == '') {
                $vorwahl = '49';
            }
            $nummer = $vorwahl . $nummer;
            if (strlen($nummer) < 5) {
                $smarty->assign('whatsapp_support_number', '');
            } else {
                $smarty->assign('whatsapp_support_number', $nummer);
            }
            $smarty->assign('whatsapp_support_btn', $this->extension->getLocalization()->getTranslation('tnt_whatsapp_lang_var_support_btn'));
            $smarty->assign(
                'whatsapp_support_text',
                vsprintf(
                    $this->extension->getLocalization()->getTranslation('tnt_whatsapp_lang_var_support_text'),
                    array('<img loading="lazy" src="' . $plugin_url . 'hand.jpg">')
                )
            );
            $smarty->assign('whatsapp_support_name', $config->getValue('tnt_whatsapp_support_name'));
            $smarty->assign('tnt_whatsapp_hide_btn', $config->getValue('tnt_whatsapp_hide_btn'));
            $smarty->assign('whatsapp_support_title', $this->extension->getLocalization()->getTranslation('tnt_whatsapp_lang_var_support_title'));
            $photo = $config->getValue('tnt_whatsapp_show_photo');
            if ($photo === 'N') {
                $smarty->assign('whatsapp_support_img', '');
            } else {
                $smarty->assign('whatsapp_support_img', $shop_url . $photo);
            }
            return true;
        }
        return false;
    }
}
