<?php declare(strict_types=1);

namespace Plugin\tnt_cartzilla\Portlets\Carousel;

use JTL\OPC\InputType;
use JTL\OPC\Portlet;
use JTL\OPC\PortletInstance;
use function __;

/**
 * Class Carousel
 * @package JTL\OPC\Portlets
 */
class Carousel extends Portlet
{

    /**
     * @return array
     */
    public function getPropertyDesc(): array
    {
        $desc = [
            'slides' => [
                'label' => __('images'),
                'type' => InputType::IMAGE_SET,
                'default' => [],
                'useLinks' => true,
                'useTitles' => true,
            ],
        ];

        return $desc;
    }

    /**
     * @return array
     */
    public function getPropertyTabs(): array
    {
        return [
            __('Slides') => ['slides'],
            __('Styles') => 'styles',
        ];
    }
}
