<?php declare(strict_types=1);

namespace Plugin\tnt_social_approve;

use JTL\Alert\Alert;
use JTL\Catalog\Category\Kategorie;
use JTL\Catalog\Product\Artikel;
use JTL\Consent\Item;
use JTL\Events\Dispatcher;
use JTL\Events\Event;
use JTL\Helpers\Form;
use JTL\Helpers\Request;
use JTL\Link\LinkInterface;
use JTL\Plugin\Bootstrapper;
use JTL\Shop;
use JTL\Smarty\JTLSmarty;
use function error_log;
use const HOOK_IO_HANDLE_REQUEST;
use const HOOK_SMARTY_OUTPUTFILTER;

class Bootstrap extends Bootstrapper
{
    private $helper;

    public function boot(Dispatcher $dispatcher)
    {
        parent::boot($dispatcher);

        if (Shop::isFrontend() === false) {
            return;
        }
        $plugin       = $this->getPlugin();
        $this->helper = new tntHelper(
            $plugin,
            $this->getDB()
        );
        if ($plugin->getConfig()->getValue('tnt_social_approve_active') === 'Y') {
            $dispatcher->listen(
                'shop.hook.' . HOOK_SMARTY_OUTPUTFILTER,
                array($this->helper, 'render')
            );
            if ($plugin->getConfig()->getValue('tnt_social_approve_sessions') === 'Y') {
                $dispatcher->listen(
                    'shop.hook.' . HOOK_IO_HANDLE_REQUEST,
                    array($this->helper, 'ioRequest')
                );
            }
        }
    }

    public function installed()
    {
        parent::installed();
    }

    public function updated($oldVersion, $newVersion)
    {
        error_log('updated from ' . $oldVersion . ' to ' . $newVersion);
    }

    public function uninstalled(bool $deleteData = true)
    {
        parent::uninstalled($deleteData);
    }
}
