<?php declare(strict_types=1);

namespace Plugin\tnt_social_approve;

use JTL\Cache\JTLCacheInterface;
use JTL\DB\DbInterface;
use JTL\DB\ReturnType;
use JTL\Helpers\Form;
use JTL\Plugin\PluginInterface;
use JTL\Shop;
use JTL\IO\IO;
use JTL\IO\IOResponse;
use JTL\Media\Image\Product;
use JTL\Media\MediaImageRequest;
use stdClass;

class tntHelper
{

    private $db;
    private $extension;

    public function __construct(PluginInterface $extension, DbInterface $db)
    {
        $this->extension = $extension;
        $this->db        = $db;
        /*
        //Replace kArtikel anhand von cArtNr
        $tmp = $this->db->queryPrepared(
                'SELECT tartikel.kArtikel, tartikel.cArtNr FROM tartikel',
                [],
                ReturnType::ARRAY_OF_OBJECTS
        );
        foreach($tmp as $art){
            $this->db->query(
                "UPDATE twarenkorbpos
                SET kArtikel = ".intval($art->kArtikel)."
                WHERE cArtNr LIKE '".$art->cArtNr."'"
            );
        }
        exit;
        */
    }

    public function ioRequest(array $args): object
    {
        $result = new IOResponse();
        $io     = $args['io'];
        if ($args[0] == 213) {
            $io->register('tnt_social_approve.io', function ($b, $a) {
                if ($b != '' && $a != '') {
                    $a = intval($a);
                    $b = intval($b);
                    if (!isset($_SESSION['tnt_approve_bestellungen'])) {
                        $_SESSION['tnt_approve_bestellungen'] = array();
                    }
                    if (!isset($_SESSION['tnt_approve_bestellungen'][$b])) {
                        $_SESSION['tnt_approve_bestellungen'][$b] = array();
                    }
                    $_SESSION['tnt_approve_bestellungen'][$b][$a] = '';
                }
            });
            $obj = json_decode($args['request']);
            if ($obj->name == 'tnt_social_approve.io') {
                if (isset($obj->params)) {
                    if (isset($obj->params->b) && isset($obj->params->a)) {
                        $io->execute('tnt_social_approve.io', array($obj->params->b, $obj->params->a));
                    }
                }
            }
        }
        return $result;
    }

    public function render(): void
    {
        $smarty  = Shop::Smarty();
        $dbRes   = $this->getLastBoughtFromDB();
        $file    = $this->extension->getPaths()->getFrontendPath() . 'template/toast.tpl';
        $shopUrl = Shop::getURL(true);
        $cnt     = 0;

        if (count($dbRes) > 0) {
            $config       = $this->extension->getConfig();
            $min          = intval($config->getValue('tnt_social_approve_random_range_min'));
            $max          = intval($config->getValue('tnt_social_approve_random_range_max'));
            $limit        = intval($config->getValue('tnt_social_approve_limit'));
            $session_once = $config->getValue('tnt_social_approve_sessions');
            $show_name    = $config->getValue('tnt_social_approve_show_name');

            $max_seconds = ((intval($config->getValue('tnt_social_approve_range')) * 24) * 60) * 60;
            if ($config->getValue('tnt_social_approve_random') === 'Y') {
                shuffle($dbRes);
            }
            unset($_SESSION['tnt_approve_bestellungen']);
            if ($session_once === 'Y') {
                if (!isset($_SESSION['tnt_approve_bestellungen'])) {
                    $_SESSION['tnt_approve_bestellungen'] = array();
                }
            }

            foreach ($dbRes as $obj) {
                if (isset($obj->kArtikel)) {
                    if ($obj->kArtikel != '0') {
                        $to_time   = strtotime($obj->dErstellt);
                        $from_time = strtotime('now');
                        $diff_time = round(abs($to_time - $from_time), 0);
                        if ($diff_time > $max_seconds) {
                            continue;
                        }
                        if ($cnt >= $limit && $limit > 0) {
                            break;
                        }

                        if ($session_once === 'Y') {
                            if (isset($_SESSION['tnt_approve_bestellungen'][$obj->kBestellung])) {
                                if (isset($_SESSION['tnt_approve_bestellungen'][$obj->kBestellung][$obj->kArtikel])) {
                                    continue;
                                }
                            }
                        }

                        $smarty->assign('tnt_social_approve_showtime', rand($min, $max) * 1000);
                        $time_ago = '';
                        $n        = 1;
                        //if($obj->cTopArtikel == "Y")$n = 2;
                        $product = new Product();
                        $img_no  = $product->getPrimaryNumber((int)$obj->kArtikel);
                        if (is_null($img_no)) {
                            continue;
                        }
                        $mediaRequest = new MediaImageRequest();
                        $mediaRequest->setNumber($img_no);
                        $mediaRequest->setID((int)$obj->kArtikel);
                        $image = $mediaRequest->getThumb('sm');

                        $smarty->assign('tnt_social_approve_img_src', $shopUrl . '/' . $image);
                        $smarty->assign('tnt_social_approve_url', $shopUrl . '/' . $obj->cSeo);
                        $smarty->assign('tnt_social_approve_img_alt', $obj->cName);
                        $smarty->assign('tnt_social_approve_b', $obj->kBestellung);
                        $smarty->assign('tnt_social_approve_a', $obj->kArtikel);
                        $smarty->assign('tnt_social_approve_io', $session_once);

                        if ($show_name === 'Y') {
                            $kunde = $obj->cVorname;
                            if ($kunde == '') {
                                $kunde = $this->extension->getLocalization()->getTranslation(
                                    'tnt_social_approve_lang_var_somebody'
                                );
                            }
                        } else {
                            $kunde = $this->extension->getLocalization()->getTranslation(
                                'tnt_social_approve_lang_var_somebody'
                            );
                        }

                        $smarty->assign(
                            'tnt_social_approve_lang_var_has_bought',
                            $kunde . ' ' .
                            vsprintf(
                                $this->extension->getLocalization()->getTranslation(
                                    'tnt_social_approve_lang_var_has_bought'
                                ),
                                array('<strong>' . $obj->cName . '</strong>')
                            )
                        );

                        if ($diff_time > 31536000) {
                            $time_ago = round($diff_time / 31536000, 0);
                            if ($time_ago > 1) {
                                $unit = $this->extension->getLocalization()->getTranslation(
                                    'tnt_social_approve_lang_var_years'
                                );
                            } else {
                                $unit = $this->extension->getLocalization()->getTranslation(
                                    'tnt_social_approve_lang_var_year'
                                );
                            }
                            $time_ago = $time_ago . ' ' . $unit;
                        } elseif ($diff_time > 2678400) {
                            $time_ago = round($diff_time / 2678400, 0);
                            if ($time_ago > 1) {
                                $unit = $this->extension->getLocalization()->getTranslation(
                                    'tnt_social_approve_lang_var_months'
                                );
                            } else {
                                $unit = $this->extension->getLocalization()->getTranslation(
                                    'tnt_social_approve_lang_var_month'
                                );
                            }
                            $time_ago = $time_ago . ' ' . $unit;
                        } elseif ($diff_time > 604800) {
                            $time_ago = round($diff_time / 604800, 0);
                            if ($time_ago > 1) {
                                $unit = $this->extension->getLocalization()->getTranslation(
                                    'tnt_social_approve_lang_var_weeks'
                                );
                            } else {
                                $unit = $this->extension->getLocalization()->getTranslation(
                                    'tnt_social_approve_lang_var_week'
                                );
                            }
                            $time_ago = $time_ago . ' ' . $unit;
                        } elseif ($diff_time > 86400) {
                            $time_ago = round($diff_time / 86400, 0);
                            if ($time_ago > 1) {
                                $unit = $this->extension->getLocalization()->getTranslation(
                                    'tnt_social_approve_lang_var_days'
                                );
                            } else {
                                $unit = $this->extension->getLocalization()->getTranslation(
                                    'tnt_social_approve_lang_var_day'
                                );
                            }
                            $time_ago = $time_ago . ' ' . $unit;
                        } elseif ($diff_time > 3600) {
                            $time_ago = round($diff_time / 3600, 0);
                            if ($time_ago > 1) {
                                $unit = $this->extension->getLocalization()->getTranslation(
                                    'tnt_social_approve_lang_var_hours'
                                );
                            } else {
                                $unit = $this->extension->getLocalization()->getTranslation(
                                    'tnt_social_approve_lang_var_hour'
                                );
                            }
                            $time_ago = $time_ago . ' ' . $unit;
                        } elseif ($diff_time > 60) {
                            $time_ago = round($diff_time / 60, 0);
                            $time_ago = $time_ago . ' ' . $this->extension->getLocalization()->getTranslation(
                                'tnt_social_approve_lang_var_minutes'
                            );
                        } else {
                            $time_ago = $diff_time . ' ' . $this->extension->getLocalization()->getTranslation(
                                'tnt_social_approve_lang_var_seconds'
                            );
                        }
                        if ($time_ago == '') {
                            $smarty->assign('tnt_social_approve_lang_var_bought_time', '');
                        } else {
                            $smarty->assign(
                                'tnt_social_approve_lang_var_bought_time',
                                vsprintf(
                                    $this->extension->getLocalization()->getTranslation(
                                        'tnt_social_approve_lang_var_bought_time'
                                    ),
                                    array($time_ago)
                                )
                            );
                        }
                        $smarty->assign('tnt_social_approve_show_buy_time', $config->getValue(
                            'tnt_social_approve_show_buy_time'
                        ));
                        $smarty->assign('tnt_social_approve_css_main', $config->getValue(
                            'tnt_social_approve_css_main'
                        ));
                        $smarty->assign('tnt_social_approve_css_text', $config->getValue(
                            'tnt_social_approve_css_text'
                        ));
                        $tpl = $smarty->fetch($file);
                        pq('body')->append($tpl);
                        $cnt++;
                    }
                }
            }
        }
    }

    public function getLastBoughtFromDB(): array
    {
        return $this->db->queryPrepared(
            'SELECT tbestellung.kBestellung, tbestellung.dErstellt, tkunde.cVorname, twarenkorbpos.cName,
                twarenkorbpos.kArtikel, tartikel.cTopArtikel, tartikel.cSeo
                FROM tbestellung
                    RIGHT JOIN tkunde
                        ON tbestellung.kKunde = tkunde.kKunde
                    RIGHT JOIN twarenkorbpos
                        ON tbestellung.kWarenkorb = twarenkorbpos.kWarenkorb
                    RIGHT JOIN tartikel
                        ON twarenkorbpos.kArtikel = tartikel.kArtikel AND twarenkorbpos.kArtikel > 0
                WHERE tbestellung.cStatus > 2
                ORDER BY tbestellung.kBestellung DESC',
            [],
            ReturnType::ARRAY_OF_OBJECTS
        );
    }
}
